<?php

namespace Eduweb\PuntLib;

use Illuminate\Database\Eloquent\Model;

class Toetsenlijst extends Model 
{

    protected $table = 'toetsenlijst';
    public $timestamps = true;
    protected $fillable = array('toetsenlijst-type_id', 'lesopdracht_id');
    protected $visible = array('toetsenlijst-type_id', 'lesopdracht_id');

    public function toetsenlijst-type()
    {
        return $this->hasOne('Eduweb\PuntLib\ToetsenlijstType', 'toetsenlijst-type_id');
    }

    public function lesopdracht()
    {
        return $this->hasOne('Eduweb\CoreLib\Lesopdracht', 'lesopdracht_id');
    }

    public function toetsen()
    {
        return $this->hasMany('Eduweb\PuntLib\Toets');
    }

}